/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.coremod.client.gui.huts.WindowHutWorkerModulePlaceholder;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.modules.settings.BoolSetting;
import com.minecolonies.coremod.colony.buildings.modules.settings.SettingKey;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingWorkerView;
import com.minecolonies.coremod.colony.jobs.JobShepherd;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class BuildingShepherd
extends AbstractBuildingWorker {
    public static final ISettingKey<BoolSetting> DYEING = new SettingKey<BoolSetting>(BoolSetting.class, new ResourceLocation("minecolonies", "dyeing"));
    public static final ISettingKey<BoolSetting> SHEARING = new SettingKey<BoolSetting>(BoolSetting.class, new ResourceLocation("minecolonies", "shearing"));
    private static final String SHEPHERD = "shepherd";
    private static final String HUT_NAME = "shepherdhut";
    private static final int MAX_BUILDING_LEVEL = 5;

    public BuildingShepherd(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return SHEPHERD;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public String getJobName() {
        return SHEPHERD;
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return Skill.Focus;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return Skill.Strength;
    }

    @Override
    @NotNull
    public IJob<?> createJob(ICitizenData citizen) {
        return new JobShepherd(citizen);
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.shepherd;
    }

    @Override
    public boolean canEat(ItemStack stack) {
        if (stack.func_77973_b() == Items.field_151015_O) {
            return false;
        }
        return super.canEat(stack);
    }

    public static class View
    extends AbstractBuildingWorkerView {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutWorkerModulePlaceholder<View>(this, BuildingShepherd.HUT_NAME);
        }
    }
}

